# SAMMv2 Summit Minneapolis

When: 13-14 October 2018  
Location: Dinkytown loft in Minneapolis, Minnesota, US
Participants:
* Bart De Win
* Chris Cooper
* Daniel Kefer
* Hardik Parekh
* John Di Leo
* Nessim Kisserli
* Sebastien Deleersnyder
* Yan Kravchenko

## Main outcomes
The team worked hard and created the following outcomes.

## Updated SAMMV2 beta draft activities
We reviewed and updated the SAMMv2 activities for all the business functions.
All SAMMv2 activities now have a description and have been reviewed in terms of content and location in the SAMMv2 structure.
Feedback is captured as direct inline editing and by adding update remarks in the Notes section of the Action.
The latest version is available here: https://owaspsamm.org/  
**Next steps:**
* Create a glossary of our terminology (owner = John)
* Create/complete our list of main SAMM principles (owner = Bart)
* Start to hire a technical writer
    * Create a statement of work (Seba)
    * Hire a technical writer (Seba)
* Each Business Function owner will integrate these notes in the next update of the Action and add any remaining questions or issues as a GitHub Issue with the appropriate Labels.   (BF owner)
(For information, there is now a label for each Security Practice in SAMMv2)

## SAMMv2.0 to SAMMv1.5 mapping
We started mapping SAMMv1.5 activities to SAMMv2.0 activities.
The goal is to:
1. Support migration towards SAMMv2 for SAMM1.5 users.
2. Detect any activities in SAMM1.5 which are not mapped, but we still want to recover in the new SAMMv2.0 core model.
3. Create a list of SAMM1.5 activities that are deprecated.
The current mapping (started, not complete) is available here:
https://github.com/OWASP/samm/edit/master/Supporting%20Resources/v2.0/summit-201810-Minneapolis/SAMM1.5-SAMM2.0%20Mapping%20Minneapolis%20v20181014.xlsx  
**Next steps:**
* Complete the mapping. (Seba)
* Create a matrix overview of the SAMMv2 structure (Bart)

## SAMM Assessment Model
In this session, the goal was to discuss possible improvement in current assessment methodology.
More details available here: https://github.com/OWASP/samm/edit/master/Supporting%20Resources/v2.0/summit-201810-Minneapolis/assessment-session.md  
**Next steps:**
* Daniel will present the concept in the next call in order to align with the team. (Daniel)
* Schedule a dedicated call on this together with Daniel 
* Everybody will try to:
1. clearly describe an objective/benefit for every maturity level of every stream (one sentence summary) (All)
2. add multiple comprehensive "Indicators of quality" formulated in the way "Typically, on this maturity level, ..." (All)

## SAMMv2 data model
During the summit, we created the SAMMv2 data model.  This is a supporting model to cover all the data elements, relationships and characteristics that are necessary to describe the core data model.  
The model is available here: https://github.com/OWASP/samm/blob/master/v2.0/DataModel.xml  
You can view/edit this with https://www.draw.io/  
**Next steps:**
* use and update the model to create the next online version of the website. (Chris)

## SAMMv2 benchmark project
It is key for SAMM to have a significant and qualitative dataset, so we have to invest more in getting this up and running, and used. By the time we want to release SAMM v2 (June 2019), the goal should be to have a 100-element dataset.
See https://github.com/OWASP/samm/edit/master/Supporting%20Resources/v2.0/summit-201810-Minneapolis/Benchmarking%20discussion%2014102018.md  
**Next steps:**  
* Discuss with Brian and Bruce by our next SAMM call no 24-Oct (Bart)

## SAMMv2 marketing and promotion
Chris created a mockup for the next draft version of the OWASP SAMM website.   
We reviewed the mockup, Chris will create the next release in the coming months.  
An outline of the SAMMv2 marketing and promotion plan has been created:
https://github.com/OWASP/samm/edit/master/Supporting%20Resources/v2.0/summit-201810-Minneapolis/SAMM2%20marketing%20and%20promotion.md  
**Next steps:**
1. Prepare / send communication on the summit outcomes (Seba)
2. Create first statement of work for our SAMM marketing support. (Seba)
3. Hire marketing/promotion resource (Seba)
4. Create the next version of the website (Chris)


## Lessons learned
We have the following lessons learned:
1. Take a picture with the whole team
2. ...
